package com.agilex.healthcare.directscheduling.domain.facility;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlAccessType;

import com.agilex.healthcare.directscheduling.domain.Namespace;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

@XmlRootElement(name = "facilities", namespace = Namespace.DirectScheduling)
@XmlAccessorType(value = XmlAccessType.NONE)
public class DSFacilities implements Serializable {

	private static final long serialVersionUID = -6970657909566889377L;
	private List<DSFacility> facilityList;

	@JsonCreator
	public DSFacilities() {
		facilityList = new ArrayList<DSFacility>();
	}

	@JsonProperty("facilityProviderList")
	@XmlElement(name = "facilityProviderList")
	public List<DSFacility> getFacilityList() {
		return facilityList;
	}

	public void setFacilityList(List<DSFacility> facilityList) {
		this.facilityList.clear();
		this.facilityList.addAll(facilityList);
	}
}
